/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import jclass.table3.TableData;
import jclass.table3.TableDataEvent;
import jclass.table3.TableDataListener;
import jclass.table3.TableDataSupport;
import jclass.util.JCVector;

public class CachedDataSource
extends TableDataSupport
implements TableDataListener {
    TableData dataSource;
    JCVector cached_row_labels = new JCVector();
    JCVector cached_column_labels = new JCVector();
    JCVector cached_cells = new JCVector();

    public CachedDataSource(TableData tableData) {
        this.dataSource = tableData;
        this.dataSource.addTableDataListener(this);
    }

    public int getNumRows() {
        return this.dataSource.getNumRows();
    }

    public int getNumColumns() {
        return this.dataSource.getNumColumns();
    }

    public Object getTableDataItem(int n, int n2) {
        if (n > this.cached_cells.size() - 1) {
            Object object = this.dataSource.getTableDataItem(n, n2);
            JCVector jCVector = new JCVector();
            jCVector.setElementAt(n2, object);
            this.cached_cells.setElementAt(n, jCVector);
            return object;
        }
        JCVector jCVector = (JCVector)this.cached_cells.elementAt(n);
        if (jCVector == null) {
            jCVector = new JCVector();
        }
        if (n2 > jCVector.size() - 1 || jCVector.elementAt(n2) == null) {
            Object object = this.dataSource.getTableDataItem(n, n2);
            jCVector.setElementAt(n2, object);
            this.cached_cells.setElementAt(n, jCVector);
            return object;
        }
        return ((JCVector)this.cached_cells.elementAt(n)).elementAt(n2);
    }

    public Object getTableRowLabel(int n) {
        if (n > this.cached_row_labels.size() - 1 || this.cached_row_labels.elementAt(n) == null) {
            Object object = this.dataSource.getTableRowLabel(n);
            this.cached_row_labels.setElementAt(n, object);
            return object;
        }
        return this.cached_row_labels.elementAt(n);
    }

    public Object getTableColumnLabel(int n) {
        if (n > this.cached_column_labels.size() - 1 || this.cached_column_labels.elementAt(n) == null) {
            Object object = this.dataSource.getTableColumnLabel(n);
            this.cached_column_labels.setElementAt(n, object);
            return object;
        }
        return this.cached_column_labels.elementAt(n);
    }

    public void dataChanged(TableDataEvent tableDataEvent) {
        int n = tableDataEvent.getRow();
        int n2 = tableDataEvent.getColumn();
        switch (tableDataEvent.getCommand()) {
            case 1: {
                try {
                    ((JCVector)this.cached_cells.elementAt(n)).setElementAt(n2, null);
                }
                catch (Exception exception) {}
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                this.cached_row_labels = new JCVector();
                this.cached_cells = new JCVector();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                this.cached_column_labels = new JCVector();
                this.cached_cells = new JCVector();
                break;
            }
            case 8: {
                this.cached_row_labels.setElementAt(n, null);
                break;
            }
            case 9: {
                this.cached_column_labels.setElementAt(n2, null);
                break;
            }
            case 14: {
                this.cached_row_labels = new JCVector();
                this.cached_column_labels = new JCVector();
                this.cached_cells = new JCVector();
                break;
            }
        }
        this.fireTableDataEvent(tableDataEvent);
    }
}

